﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPageExt.master" AutoEventWireup="true" CodeFile="reports_stat.aspx.cs" Inherits="reports_stat" %>

<%@ Register Assembly="Ext.Net" Namespace="Ext.Net" TagPrefix="ext" %>
<%@ MasterType VirtualPath="~/MasterPageExt.master" %>



<asp:Content ID="Content1" ContentPlaceHolderID="cpHeader" runat="Server">
    <style type="text/css">
        .x-tree-checkbox-fill
        {
            margin-right: 3px;
            top: 4px;
            width: 13px;
            height: 13px;
            background-image: url("./Images/checkbox-fill.png");
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <script type="text/javascript">

        function AriaExportReqSaveBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        function AriaExpCancBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        function AriaSubmitRepBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        function AriaCansReqBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        function AriaDownloadCSVBtn(el) {
            el.set({
                "role": 'button'
            });
        }

        function OnRequestSel(status_code)
        {
            App.btnCancelRequest.setDisabled(true);
            App.btnDownloadCSV.setDisabled(true);

            //2 = ready for download
            if (status_code == 2)
            {
                App.btnDownloadCSV.enable();
            }

            //1 = request in progress
            if (status_code == 1)
            {
                App.btnDownloadCSV.setDisabled(true);
                App.btnCancelRequest.setDisabled(false);
            }
        }
    </script>

    <ext:Window ID="winExportRequest"
        runat="server"
        Closable="false"
        Constrain="true"
        ConstrainToElement="pnlMainWorkspace"
        Icon="Page"
        BodyPadding="6"
        Width="425"
        Height="200"
        AutoHeight="true"
        Hidden="true"
        Title="New Data Extract"
        IDMode="Static"
        
        Modal="true"
        Collapsible="false"
        Resizable="false"
        Maximizable="false"
        Draggable="false" 
        XOnEsc="Ext.emptyFn">
        <Items>
            <ext:Panel runat="server" MinHeight="350" BodyStyle="text-align: left; margin-top: 10px;" Border="false">
                <Items>
                    <ext:Panel Border="false"
                        Layout="VBoxLayout"
                        AnchorHorizontal="100%"
                        AnchorVertical="100%"
                        runat="server"
                        Padding="3"
                        Width="400">
                        <LayoutConfig>
                            <ext:VBoxLayoutConfig Align="Stretch" />
                        </LayoutConfig>
                        <Items>
                            <ext:TextField
                                ID="txtExportRequestName"
                                runat="server"
                                AllowBlank="false"
                                FieldLabel="Request Name"
                                LabelWidth="100"
                                MinLength="1"
                                MaxLength="255"
                                EnforceMaxLength="true"
                                Padding="5">
                                <Listeners>
                                    <Change Handler="fnValidateExportRequestWindow();" />
                                </Listeners>
                            </ext:TextField>
                        </Items>
                    </ext:Panel>
                </Items>
            </ext:Panel>
        </Items>
        <BottomBar>
            <ext:Toolbar runat="server">
                <Items>
                    <ext:Button ID="btnExportRequestSave" runat="server" Text="Save" Icon="Disk">
                        <Listeners>
                            <AfterRender Handler="AriaExportReqSaveBtn(App.btnExportRequestSave.getEl());" ></AfterRender>
                            <Click Handler="fnSaveExportRequest();" />
                        </Listeners>
                    </ext:Button>
                    <ext:Button ID="btnExportRequestCancel" runat="server" Text="Cancel" Icon="Cancel">
                        <Listeners>
                            <AfterRender Handler="AriaExpCancBtn(App.btnExportRequestCancel.getEl());" ></AfterRender>
                            <Click Handler="App.winExportRequest.hide();"></Click>
                        </Listeners>
                    </ext:Button>
                </Items>
            </ext:Toolbar>
        </BottomBar>
        <Listeners>
            <Show Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();" />
            <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
            <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />

        </Listeners>
    </ext:Window>

    <ext:Panel ID="pnlReportsStatMain"
        IDMode="Static"
        runat="server"
        AnchorHorizontal="100%"
        AnchorVertical="100%"
        Layout="BorderLayout"
        AutoDoLayout="true"
        Border="false"
        Frame="false">
        <Items>
            <ext:Panel ID="pnlWest"
                Title=""
                Split="true"
                Header="true"
                Collapsible="false"
                Layout="BorderLayout"
                runat="server"
                Region="West"
                Border="false"
                Frame="false"
                AnchorHorizontal="100%"
                AnchorVertical="100%"
                Flex="1"
                MinWidth="380">
                <Items>
                    <ext:Panel ID="pnlFilters"
                        runat="server"
                        Title="Data Extract"
                        Icon="Lightning"
                        Region="Center"
                        Split="true"
                        Border="false"
                        Flex="1"
                        MaintainFlex="true"
                        Layout="VBoxLayout"
                        Frame="false"
                        Disabled="false">
                        <LayoutConfig>
                            <ext:VBoxLayoutConfig Align="Stretch" />
                        </LayoutConfig>
                        <Items>
                            <ext:Panel ID="pnlRequestIdentity"
                                runat="server"
                                Border="false"
                                Frame="false"
                                Layout="ColumnLayout"
                                Padding="5"
                                MaxWidth="700">
                                <Items>
                                    <ext:FieldSet
                                        runat="server"
                                        Border="false"
                                        Title=""
                                        CheckboxToggle="false"
                                        Collapsed="false"
                                        Collapsible="false"
                                        Layout="ColumnLayout"
                                        ColumnWidth="0.95">
                                        <Items>
                                            <ext:TextField ID="tfRequestName"
                                                runat="server"
                                                FieldLabel="Title"
                                                LabelWidth="120"
                                                Padding="5"
                                                ColumnWidth="0.95"
                                                MaxWidth="620"
                                                MinLength="3"
                                                Vtype="alphanumXSS">
                                                <Listeners>
                                                    <Change Fn="fnSTATValForm" />
                                                </Listeners>
                                            </ext:TextField>
                                        </Items>
                                    </ext:FieldSet>
                                </Items>
                            </ext:Panel>
                            <ext:Panel ID="pnlFiltersSelection"
                                runat="server"
                                Border="false"
                                Frame="false"
                                Layout="ColumnLayout"
                                Padding="5"
                                MaxWidth="700">
                                <Items>
                                    <ext:FieldSet
                                        runat="server"
                                        Border="false"
                                        Title="FILTERS"
                                        CheckboxToggle="false"
                                        Collapsed="false"
                                        Collapsible="false"
                                        Layout="ColumnLayout"
                                        ColumnWidth="0.95">
                                        <Items>
                                            <ext:Panel ID="pnlFilterDateRange"
                                                runat="server"
                                                Border="false"
                                                Frame="false"
                                                Layout="ColumnLayout"
                                                ColumnWidth="1.0">
                                                <Items>
                                                    <ext:DateField ID="dfFromDate"
                                                        runat="server"
                                                        AllowBlank="false"
                                                        AutoDataBind="true"
                                                        Width="300"
                                                        FieldLabel="Date range"
                                                        LabelWidth="120"
                                                        Padding="5"
                                                        Format="MM/dd/yyyy"
                                                        Vtype="date"
                                                        InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                                        <Listeners>
                                                            <Change Fn="fnSTATValForm" />
                                                        </Listeners>
                                                    </ext:DateField>
                                                    <ext:DateField ID="dfToDate"
                                                        runat="server"
                                                        AllowBlank="false"
                                                        AutoDataBind="true"
                                                        Width="300"
                                                        FieldLabel="To"
                                                        LabelWidth="120"
                                                        Padding="5"
                                                        Format="MM/dd/yyyy"
                                                        Vtype="date"
                                                        InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                                        <Listeners>
                                                            <Change Fn="fnSTATValForm" />
                                                        </Listeners>
                                                    </ext:DateField>
                                                </Items>
                                            </ext:Panel>
                                            <ext:Panel ID="pnlFilterLocation"
                                                runat="server"
                                                Border="false"
                                                Frame="false"
                                                Layout="ColumnLayout"
                                                ColumnWidth="1">
                                                <Items>
                                                    <ext:ComboBox
                                                        ID="cboFilterRegion"
                                                        runat="server"
                                                        Editable="false"
                                                        ValueField="REGION_ID"
                                                        DisplayField="REGION_NAME"
                                                        Width="300"
                                                        FieldLabel="Location - Region" AutoDataBind="false"
                                                        LabelWidth="120"
                                                        Padding="5">
                                                        <Store>
                                                            <ext:Store ID="storeFilterRegion" AutoLoad="false" runat="server">
                                                                <Model>
                                                                    <ext:Model ID="modFilterRegion" runat="Server" IDProperty="REGION_ID">
                                                                        <Fields>
                                                                            <ext:ModelField Name="REGION_ID" />
                                                                            <ext:ModelField Name="REGION_NAME" />
                                                                        </Fields>
                                                                    </ext:Model>
                                                                </Model>
                                                                <Reader>
                                                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                                                    </ext:JsonReader>
                                                                </Reader>
                                                            </ext:Store>
                                                        </Store>
                                                        <Listeners>
                                                            <Change Handler="Ext.defer(fnOnFilterRegionClearSel(), 1); 
                                                                             Ext.defer(fnOnFilterRegionChange(newValue), 1); 
                                                                             " />
                                                        </Listeners>
                                                    </ext:ComboBox>
                                                    <ext:ComboBox
                                                        ID="cboFilterSite"
                                                        runat="server"
                                                        Editable="false"
                                                        ValueField="SITE_ID"
                                                        DisplayField="SITE_NAME"
                                                        Width="300"
                                                        FieldLabel="Site"
                                                        LabelWidth="120"
                                                        Padding="5">
                                                        <Store>
                                                            <ext:Store ID="storeFilterSite" AutoLoad="true" runat="server">
                                                                <Model>
                                                                    <ext:Model ID="modFilterSite" runat="Server" IDProperty="SITE_ID">
                                                                        <Fields>
                                                                            <ext:ModelField Name="SITE_ID" />
                                                                            <ext:ModelField Name="SITE_NAME" />
                                                                        </Fields>
                                                                    </ext:Model>
                                                                </Model>
                                                                <Reader>
                                                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                                                    </ext:JsonReader>
                                                                </Reader>
                                                            </ext:Store>
                                                        </Store>
                                                        <Listeners>
                                                            <Change Handler="fnOnFilterSiteChange(newValue);" />
                                                        </Listeners>
                                                    </ext:ComboBox>
                                                </Items>
                                            </ext:Panel>
                                            <ext:Panel ID="pnlFilterProgram"
                                                runat="server"
                                                Border="false"
                                                Frame="false"
                                                Layout="ColumnLayout"
                                                ColumnWidth="1">
                                                <Items>
                                                    <ext:ComboBox
                                                        ID="cboFilterProgram"
                                                        runat="server"
                                                        Editable="false"
                                                        ValueField="CPA_TYPE_ID"
                                                        DisplayField="CPA_TITLE"
                                                        Width="300"
                                                        FieldLabel="Program"
                                                        LabelWidth="120"
                                                        Padding="5">
                                                        <Store>
                                                            <ext:Store ID="storeFilterProgram" AutoLoad="true" runat="server">
                                                                <Model>
                                                                    <ext:Model ID="modFilterProgram" runat="Server" IDProperty="CPA_TITLE">
                                                                        <Fields>
                                                                            <ext:ModelField Name="CPA_TYPE_ID" />
                                                                            <ext:ModelField Name="CPA_TITLE" />
                                                                        </Fields>
                                                                    </ext:Model>
                                                                </Model>
                                                                <Reader>
                                                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                                                    </ext:JsonReader>
                                                                </Reader>
                                                            </ext:Store>
                                                        </Store>
                                                    </ext:ComboBox>
                                                </Items>
                                            </ext:Panel>
                                            <ext:Panel ID="pnlFilterClinical"
                                                runat="server"
                                                Border="false"
                                                Frame="false"
                                                Layout="ColumnLayout"
                                                ColumnWidth="1">
                                                <Items>
                                                    <ext:Checkbox
                                                        ID="chkInpatient"
                                                        runat="server"
                                                        BoxLabel="Inpatient"
                                                        FieldLabel="Clinical Setting"
                                                        LabelWidth="120"
                                                        Padding="5" />
                                                    <ext:Checkbox
                                                        ID="chkOutpatient"
                                                        runat="server"
                                                        BoxLabel="Outpatient"
                                                        Padding="5" />
                                                </Items>
                                            </ext:Panel>
                                        </Items>
                                    </ext:FieldSet>
                                </Items>
                            </ext:Panel>
                            <ext:Panel ID="pnlDataSelection"
                                runat="server"
                                Split="true"
                                Flex="1"
                                MaintainFlex="true"
                                Layout="VBoxLayout"
                                Border="false"
                                Frame="false"
                                Disabled="false">
                                <LayoutConfig>
                                    <ext:VBoxLayoutConfig Align="Stretch" />
                                </LayoutConfig>
                                <BottomBar>
                                    <ext:Toolbar
                                        ID="toolbarMyRequest"
                                        runat="server">
                                        <Items>
                                            <ext:ToolbarFill />
                                            <ext:Button ID="btnSubmitReport" runat="server" Text="Submit Data Extract" Icon="ReportGo" Disabled="false" Handler="fnOnSubmitExportRequest2();" >
                                            <Listeners>
                                               <AfterRender Handler="AriaSubmitRepBtn(App.btnSubmitReport.getEl());" ></AfterRender>
                                            </Listeners>
                                            </ext:Button>
                                        </Items>
                                    </ext:Toolbar>
                                </BottomBar>
                                <Items>
                                    <ext:TreePanel
                                        ID="tDataFields"
                                        runat="server"
                                        Title="Data to be included in the file extract:"
                                        Icon="Accept"
                                        Layout="FitLayout"
                                        Anchor="100%"
                                        UseArrows="true"
                                        Animate="true"
                                        RootVisible="false"
                                        OverflowY="Scroll"
                                        Flex="1"
                                        Border="false"
                                        Frame="false"
                                        >
                                        <Listeners>
                                            <CheckChange Fn="fnOnCheckChange" />
                                        </Listeners>
                                    </ext:TreePanel>
                                </Items>
                            </ext:Panel>
                        </Items>
                    </ext:Panel>
                </Items>
            </ext:Panel>
            <ext:Panel ID="pnlCenter"
                Title="My Requests"
                Split="true" Header="true"
                Collapsible="false"
                Layout="AnchorLayout"
                Resizable="false"
                runat="server"
                Region="Center"
                Flex="1"
                MaintainFlex="true"
                Border="false"
                Frame="false"
                Anchor="100%"
                MinWidth="100">
                <%--<TopBar>
                    <ext:Toolbar
                        ID="toolbarMyRequest"
                        runat="server">
                        <Items>
                            <ext:Button ID="spltBtnRequest" runat="server" Text="Request">
                                <Menu>
                                    <ext:Menu runat="server">
                                        <Items>
                                            <ext:MenuItem ID="btnNewRequest" Text="New..." Icon="Page" Handler="fnOnShowCreateExportRequestWindow();" />
                                            <ext:MenuItem ID="btnSaveRequest" Text="Save" Icon="Disk" Handler="fnOnSaveExportRequest();" />
                                            <ext:MenuItem ID="btnSaveAsRequest" Text="Save As..." Handler="fnOnShowSaveAsExportRequestWindow();" />
                                        </Items>
                                    </ext:Menu>
                                </Menu>
                            </ext:Button>
                            <ext:Button ID="btnSubmitReport" runat="server" Text="Submit Data Extract" Icon="ReportGo" Disabled="true" Handler="fnOnSubmitExportRequest();" />
                        </Items>
                    </ext:Toolbar>
                </TopBar>--%>
                <Items>
                    <ext:GridPanel
                        ID="gpMyRequest"
                        runat="server"
                        Title=""
                        Layout="FitLayout"
                        AnchorHorizontal="100%"
                        AnchorVertical="100%"
                        ColumnLines="true"
                        RowLines="true"
                        AutoScroll="true"
                        Flex="1"
                        Border="false">
                         <BottomBar>
                            <ext:Toolbar  runat="server">
                                <Items>
                                    <ext:Button ID="btnCancelRequest" runat="server" Text="Cancel Request"
                                         Icon="Delete" Handler="OnMyRequestActionCommand('CMD_REQUEST_CANCEL', App.gpMyRequest.getSelectionModel().getSelection()[0].data);" >
                                    <Listeners>
                                        <AfterRender Handler="AriaCansReqBtn(App.btnCancelRequest.getEl());" ></AfterRender>
                                    </Listeners>
                                    </ext:Button>

                                    <ext:Button ID="btnDownloadCSV" runat="server" Text="Download CSV File" 
                                        Icon="DiskDownload" Handler="OnMyRequestActionCommand('CMD_REQUEST_DOWNLOAD', App.gpMyRequest.getSelectionModel().getSelection()[0].data);" >
                                    <Listeners>
                                        <AfterRender Handler="AriaDownloadCSVBtn(App.btnDownloadCSV.getEl());" ></AfterRender>
                                    </Listeners>
                                    </ext:Button>
                                </Items>
                            </ext:Toolbar>
                        </BottomBar>
                        <Listeners>
                            <Select Handler="OnRequestSel(record.data.STATUS_CODE);"></Select>
                            <BeforeItemClick Fn="fnMyRequestBeforeSelect" />
                            <ItemClick Handler="fnOnLoadRequest(record.data, index);" />
                            <FilterChange Fn="fnMyRequestFilterChange" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel runat="server" Mode="Single">
                                <Listeners>
                                </Listeners>
                                <CustomConfig>
                                </CustomConfig>
                            </ext:RowSelectionModel>
                        </SelectionModel>
                        <ColumnModel runat="server">
                            <Columns>
                                <ext:Column ID="MyRequestName" runat="server"
                                    DataIndex="REPORT_NAME" Text="Title"
                                    Flex="1" >
                                    <Filter>
                                    <ext:StringFilter></ext:StringFilter>
                                    </Filter>
                                </ext:Column>
                                <ext:Column ID="MyRequestStatus" runat="server"
                                    DataIndex="STATUS_DESCRIPTION" Text="Status"
                                    Flex="1" >
                                    <Filter>
                                    <ext:ListFilter></ext:ListFilter>
                                    </Filter>
                                </ext:Column>
                                <ext:DateColumn ID="MyRequestStartDate" runat="server"
                                    DataIndex="STR_DATE" Text="Start" Format="m/dd/Y"
                                    Width="100" >
                                    <Filter>
                                    <ext:DateFilter></ext:DateFilter>
                                    </Filter>
                                </ext:DateColumn>
                                <ext:DateColumn ID="MyRequestEndDate" runat="server"
                                    DataIndex="END_DATE" Text="End" Format="m/dd/Y"
                                    Width="100" >
                                    <Filter>
                                    <ext:DateFilter></ext:DateFilter>
                                    </Filter>
                                </ext:DateColumn>
                                <ext:ImageCommandColumn Text="Action" ID="MyRequestCommand" runat="server" Width="60" Padding="3">
                                    <Commands>
                                        <%--<ext:ImageCommand CommandName="CMD_REQUEST_RENAME" Icon="PageWhiteEdit" Text="">
                                            <ToolTip Text="Rename" />
                                        </ext:ImageCommand>--%>
                                        <ext:ImageCommand CommandName="CMD_REQUEST_CANCEL" Icon="Delete" Text="">
                                            <ToolTip Text="Cancel" />
                                        </ext:ImageCommand>
                                        <ext:ImageCommand CommandName="CMD_REQUEST_DOWNLOAD" Icon="DiskDownload" Text="">
                                            <ToolTip Text="Download CSV File" />
                                        </ext:ImageCommand>
                                    </Commands>
                                    <PrepareCommand Fn="MyRequestPrepareCommand" />
                                    <Listeners>
                                        <Command Handler="OnMyRequestActionCommand(command, record.data);" />
                                    </Listeners>
                                </ext:ImageCommandColumn>
                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storeMyRequest"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlMyRequest" runat="Server" IDProperty="REQUEST_ID">
                                        <Fields>
                                            <ext:ModelField Name="REPORT_NAME" Type="String" />
                                            <ext:ModelField Name="STATUS_CODE" Type="Int" />
                                            <ext:ModelField Name="STATUS_DESCRIPTION" Type="String" />
                                            <ext:ModelField Name="STR_DATE" Type="Date" />
                                            <ext:ModelField Name="END_DATE" Type="Date" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                        <Plugins>
                            <ext:GridFilters runat="server"></ext:GridFilters>
                        </Plugins>
                                                
                    </ext:GridPanel>
                </Items>
            </ext:Panel>
        </Items>
    </ext:Panel>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cpScripts" runat="Server">
    <script src="js/reports.stat.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    fnBindExpandCollapse();
                }, 1);
            });
        });
    </script>
</asp:Content>

